"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sanitizeNextUrl = sanitizeNextUrl;
var _url = require("url");
var _path = _interopRequireDefault(require("path"));
/* eslint-disable @kbn/eslint/require-license-header */
/**
 *    Copyright 2019 floragunn GmbH

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/**
 *
 * @param nextUrl - Only the query parameter value instead of the complete url.
 * @param basePath
 * @returns {*}
 */
function sanitizeNextUrl(nextUrl, basePath) {
  const parsedNextUrl = (0, _url.parse)(nextUrl, false, true);
  const maliciousProperties = ['hostname', 'protocol', 'port'].filter(property => parsedNextUrl[property] !== null);
  if (maliciousProperties.length) {
    return basePath;
  }

  // We always need the base path
  if (nextUrl && basePath && !parsedNextUrl.pathname.startsWith(basePath)) {
    return _path.default.posix.join(basePath, nextUrl);
  }

  // All valid
  return nextUrl;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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